from datetime import date, datetime
from typing import Optional
from pydantic import BaseModel

class StepRecordBase(BaseModel):
    record_date: date
    steps_count: int
    points_earned: int
    calories_burned: Optional[float] = None
    distance_km: Optional[float] = None
    goal_achieved: Optional[bool] = False
    sync_source: Optional[str] = None

class StepRecordCreate(StepRecordBase):
    pass

class StepRecordResponse(StepRecordBase):
    id: int
    user_id: int
    created_at: datetime
    updated_at: datetime

    class Config:
        orm_mode = True

class StepRecordUpdate(BaseModel):
    steps_increment: int