from typing import Optional
from datetime import datetime
from pydantic import BaseModel, Field

class AddressBase(BaseModel):
    """주소 스키마의 기본 클래스"""
    title: str = Field(..., min_length=1, max_length=50, description="주소 구분을 위한 타이틀 (예: '집', '회사', '기타')")
    recipient_name: str = Field(..., min_length=2, max_length=100)
    address_line1: str = Field(..., min_length=5, max_length=255)
    address_line2: Optional[str] = Field(None, max_length=255)
    city: str = Field(..., min_length=2, max_length=100)
    postal_code: str = Field(..., min_length=2, max_length=20)
    country: str = Field(..., min_length=2, max_length=2)
    phone: str = Field(..., min_length=5, max_length=20)
    is_default: bool = False

class AddressCreate(AddressBase):
    """주소 생성 요청 스키마"""
    pass

class AddressUpdate(BaseModel):
    """주소 수정 요청 스키마 (모든 필드 선택적)"""
    title: Optional[str] = Field(None, min_length=1, max_length=50)
    recipient_name: Optional[str] = Field(None, min_length=2, max_length=100)
    address_line1: Optional[str] = Field(None, min_length=5, max_length=255)
    address_line2: Optional[str] = Field(None, max_length=255)
    city: Optional[str] = Field(None, min_length=2, max_length=100)
    postal_code: Optional[str] = Field(None, min_length=2, max_length=20)
    country: Optional[str] = Field(None, min_length=2, max_length=2)
    phone: Optional[str] = Field(None, min_length=5, max_length=20)
    is_default: Optional[bool] = None

class AddressResponse(AddressBase):
    """주소 응답 스키마"""
    id: int
    user_id: int
    created_at: datetime
    updated_at: datetime

    class Config:
        orm_mode = True 