from app.db.session import SessionLocal
from app.models.advertisement import Advertisement

def seed_advertisements():
    session = SessionLocal()

    # 4개의 광고 데이터를 생성합니다.
    ads = [
        Advertisement(
            ad_url="https://youtu.be/WkxCt91Jrss?si=zTpStV3wYJMT6GsL",
            video_list_order=1,
            ad_video_points=10  # 포인트는 필요에 따라 조정
        ),
        Advertisement(
            ad_url="https://youtu.be/QKWUeHQB4Q0?si=yLjJTLt3BBiJuLa5",
            video_list_order=2,
            ad_video_points=20
        ),
        Advertisement(
            ad_url="https://youtu.be/dIXW_4CP3Vk?si=yEHmxv_oove1hJH3",
            video_list_order=3,
            ad_video_points=30
        ),
        Advertisement(
            ad_url="https://youtu.be/Lc8qIvnFVwo?si=8x1D7Ru0r7GaQ8Uv",
            video_list_order=4,
            ad_video_points=50
        ),
    ]

    # 데이터베이스에 레코드 삽입
    session.add_all(ads)
    session.commit()
    session.close()

if __name__ == "__main__":
    seed_advertisements()